#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import chemin
import pygame
from helper import load_multiframe

class Traeger(object):
	def __init__(self,monde,start=[],stop=[],geb=[None,None]):
		self.route = []
		self.geb = geb[:]
		chem = []
		if (start != []) and (stop != []):
			for sta in start:
				for sto in stop:
					
					# revert nötig, da chemin.dijkstra nur eine Richtung unterstützt ... 
					if  (sto[0]-sta[0] <0) or (sto[1]-sta[1] <0): # wird sich in -x oder -y Richtung bewegt
						dep = sto ; arr= sta										# also revert
						rev= True
					else:																# wird sich in +x oder +y Richtung bewegt
						dep = sta ; arr=sto										# nicht revert
						rev = False																	
					# wird sich in +x und -y Richtung bewegt --> nicht revert (try and error)
					if (sto[0]-sta[0] >0) and (sto[1]-sta[1] <0):
						dep = sta ; arr=sto
						rev = False
					
					# Kopie der wege knoten erstellen, wenn Anfang und Ende keine Knoten, so füge sie hinzu.
					nodes2=monde.wege.nodes[:]
					if dep not in nodes2:
						nodes2.insert(0,dep)
					if arr not in nodes2:
						nodes2.append(arr)
					
					# Vorbereitung und Ausführung von chemin.dijkstra 
					roads = chemin.find_all_roads(monde.wege.wege,nodes2)	# Alle Wege: [ [[anfang],[],[ende]] , [...],... ]
					graph = chemin.graph_data(nodes2,roads)			# Daten formatieren für chemin.dijkstra
					#print "Träger: " + str(dep) +" --> "+ str(arr)
					chem = chemin.dijkstra(graph, str(dep),str(arr))
					if chem == []:
						break
					# post-Bearbeitung
					chem = chemin.convert_str_to_list(chem)
					if rev == True:
						chem.reverse()
					chem = chemin.nodes_to_list(chem,roads)
					
						
					if len(chem) != 0:
						break 
				if len(chem) != 0:
					break 
		#print "Träger: " + str(geb[0].pos) + " - " + str(geb[0].pos)
		self.route =  chem
		
		if self.route != []:
			self.dpos = [ monde.get(self.route[0]).dpos[0] , monde.get(self.route[0]).dpos[1] ]
		else:
			self.dpos  = [0,0]
		
		self.start = geb[0]
		self.end = geb[1]
		self.seen = []
		self.todo = []
		self.korr=[]
		self.typ = 40
		self.max_spe = monde.neu[40]["max_spe"]
		self.datei = monde.neu[40]["datei"]

		if monde.neu[40].get("multifr") != None:
			self.multiframe = [1,monde.neu[40]["size2"]]
		else:
			self.multiframe = [0,monde.neu[40]["size2"]]
		self.load_img(monde)

	def load_img(self,monde):
		if monde.zoom == 0:
			self.multiframe[1] = [int(monde.neu[self.typ]["size2"][0]*0.25) , int(monde.neu[self.typ]["size2"][1]*0.25)]
		elif monde.zoom == 1:
			self.multiframe[1] = [int(monde.neu[self.typ]["size2"][0]*0.5) , int(monde.neu[self.typ]["size2"][1]*0.5)]
		elif monde.zoom == 2:
			self.multiframe[1] = monde.neu[self.typ]["size2"]
			
		if self.multiframe[0] == 1:
			self.img = load_multiframe(self.datei,self.multiframe[1])	
			self.rect = self.img[0].get_rect()
		else:
			self.img = pygame.image.load(self.datei).convert_alpha() 
			self.rect = self.img.get_rect()
		self.dimg = None

		
	def forward(self,monde):
		# ist die Route noch nicht abgelaufen , so wird das gerade gelaufene Stück an die Liste mit bereits gesehenen (gelaufen) angehängt un verschwindet aus der Route
		# seen wird für den Rûckweg verwendet
		if self.route != []:
			#print "go forward to " + str(self.route[0]) 
			last_pos = self.route[0][:]
			self.seen.append(self.route[0][:])
			del self.route[0]
		
		#print self.typ
		
		
		#Laden der Bilder, je nach dem in welche Richtung der Mann geht !
		# ist Route nicht leer, Wird die letzte Position mit der aktuellen verglichen		
		if self.route != []:
			new_pos = self.route[0][:]
			if (last_pos[0] == new_pos[0]+1 ): 	# -X Richtung
				self.datei = self.datei[:-11]+"-x-z"+str(monde.zoom)+"-n.png"
			if (last_pos[0] == new_pos[0]-1):	# +X Richtung
				self.datei = self.datei[:-11]+"+x-z"+str(monde.zoom)+"-n.png"
			if (last_pos[1] == new_pos[1]+1 ): 	# -Y Richtung
				self.datei = self.datei[:-11]+"-y-z"+str(monde.zoom)+"-n.png"			
			if (last_pos[1] == new_pos[1]-1):	# +Y Richtung
				self.datei = self.datei[:-11]+"+y-z"+str(monde.zoom)+"-n.png"
			self.load_img(monde)			
			self.dpos = monde.get(self.route[0]).dpos[:]
		# Ist die Rute abgelaufen, wird self.seen benutzt ... 
		#das Ganze ist eigentlich obsolet .. man kann auch gleich seen benutzen. Muss in einer der Nächsten Versionen verbessert werden !!!
		else:
			if (last_pos[0] == self.seen[-1][0]+1 ) or (last_pos[0] == self.seen[-1][0]-1):
				self.datei = self.datei[:-11]+"+x-z"+str(monde.zoom)+"-n.png"
			if (last_pos[1] == self.seen[-1][1]+1 ) or (last_pos[1] == self.seen[-1][1]-1):	
				self.datei = self.datei[:-11]+"+y-z"+str(monde.zoom)+"-n.png"
			self.load_img(monde)
			self.dpos = monde.get(self.seen[-1]).dpos[:]

		if self.multiframe[0] == 1:
			self.rect = self.img[0].get_rect().move(self.dpos)
		else:
			self.rect = self.img.get_rect().move(self.dpos)		
		self.korr = [-self.rect.width + (monde.zoom_size[monde.zoom][0])  ,  -self.rect.height + (monde.zoom_size[monde.zoom][1])]		
		self.dpos = [ self.dpos[0] + self.korr[0] , self.dpos[1] + self.korr[1]]
		if self.multiframe[0] == 1:
			self.rect = self.img[0].get_rect().move(self.dpos)
		else:
			self.rect = self.img.get_rect().move(self.dpos)



		
class Einwohner(Traeger):
	def __init__(self,monde,start=[],stop=[],geb=[None,None]):
		Traeger.__init__(self,monde,start,stop,geb)
		self.datei = monde.neu[41]["datei"]
		#self.img = pygame.image.load(monde.neu[41]["datei"]).convert_alpha()
		#self.rect = self.img.get_rect().move(self.dpos)
		self.max_spe = monde.neu[41]["max_spe"]
		self.typ = 41
		if monde.neu[41].get("multifr") != None:
			self.multiframe = [1,monde.neu[41]["size2"]]
		else:
			self.multiframe = [0,monde.neu[41]["size2"]]
		self.load_img(monde)

class Leute(object):
	def __init__(self):
		self.leute = []
		
	def kill(self,l):
		del self.leute[self.leute.index(l)]
		
	def unterwegs(self,direction):
		ok = False				# ist schon jemand unterwegs blockiere !!
		for l in self.leute:
			if isinstance(l,Traeger) or isinstance(l,Einwohner):
				if (l.end ==  direction) or (l.start == direction):#p.get_geb(a):
					ok = True
		return ok
		
			
