#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#       untitled.py
#       
#       Copyright 2012 Johannes ter Haak <jojo@jojo3>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#       
#       



from Tkinter import *
import tkFileDialog
import os
import subprocess

path = os.path.dirname(__file__)
if path != "":
	os.chdir(path)

class main(object):
	def __init__(self):
				
		self.default_dir = os.getcwd()
		self.default_file = "map.sqlite"
		self.default_path = os.path.join(self.default_dir , self.default_file)

		self.window = Tk()
		self.window.title("JojoSettlers launcher")
		
		self.open_canvas = LabelFrame(self.window,text="öffnen")
		self.expl_label = Label(self.open_canvas,text="Zum öffnen einer bestimmten Karte bitte die Datei auswählen\nDas Spiel wird mit dem 'run' Button gestartet")
		
		self.choosefile_canv = Canvas(self.open_canvas)
		self.choosefile_entry = Entry(self.choosefile_canv,width=30)
		self.choosefile_button = Button(self.choosefile_canv , text="browse", command=self.choosefile)
		self.choosefile(ort="test")
		
		self.run_button = Button(self.open_canvas,text="run",command=self.run)
		
		self.expl_label.grid(row=0 , column=0)
		self.choosefile_canv.grid(row=1 , column=0)
		self.choosefile_entry.grid(row=0 , column=0)
		self.choosefile_button.grid(row=0 , column=1)
		self.run_button.grid(row=2,column=0)
		
		
		self.admin_canvas = LabelFrame(self.window,text="admin")
		self.admin_label = Label(self.admin_canvas,text="Bevor man eine Map öffnet muss sie speziell angefertigt verden.")
		self.create_canvas = Canvas(self.admin_canvas)
		self.create_spinb = Spinbox(self.create_canvas , from_=20 , to=60 , increment=1 , width=3)
		self.create_label = Label(self.create_canvas , text="x")
		self.create_spinb2 = Spinbox(self.create_canvas , from_=20 , to=60 , increment=1 , width=3)
		self.create_button = Button(self.admin_canvas,text="speichern",command=self.create_map)
		self.admin_label.grid(row=0,column=0)
		self.create_spinb.grid(row=0,column=0)
		self.create_label.grid(row=0,column=1)
		self.create_spinb2.grid(row=0,column=2)
		self.create_button.grid(row=2,column=0)
		self.create_canvas.grid(row=1,column=0)
		
		self.open_canvas.grid(row=0,column=0)
		self.admin_canvas.grid(row=1,column=0)
		self.window.mainloop()
		

	def run(self):
		path = self.choosefile_entry.get()
		if os.path.isfile(path):
			print "OPEN file " + str(path)
			subprocess.call(["python","main3.py","-f",str(path)])
		else: 
			print "file not found"	
			
	def choosefile(self,ort=""):
		if ort == "": 
			path = self.choosefile_entry.get()
			di= tkFileDialog.askopenfilename(initialdir=self.default_dir, initialfile=self.default_file)
			self.choosefile_entry.delete(0,END)
			self.choosefile_entry.insert(0,di)
		else:
			self.choosefile_entry.delete(0,END)
			self.choosefile_entry.insert(0,self.default_path)
			
	def create_map(self):
		size = str(self.create_spinb.get())+"x"+str(self.create_spinb2.get())
		di= tkFileDialog.asksaveasfilename(initialdir=self.default_dir, initialfile="jojosettlers-map.sqlite")
		subprocess.call(["python","map2.py","-f",str(di),"-s",size])
			
	


			
m = main()
