#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
import pygame
import os
pygame.font.init()
from HTMLParser import HTMLParser

class colortext(HTMLParser):
	def __init__(self):
		HTMLParser.__init__(self)
		self.txt = []
		self.ctxt = []
		self.index = 0
		self.col = False
		
	def handle_starttag(self, tag, attrs):
		# format: 	<spam style="color:#RRGGBB" > colored text</span>
		if (tag == "span"):
			style=""
			for attr in attrs:
				if attr[0] == "style":
					style= attr[1]
			
			if style != "":	
				color = ""
				for el in style.split(";"):
					if el[:6] == "color:":
						color = el[7:]
				if len(color) == 6:
					color= (int(color[0:2],16) , int(color[2:4],16)	,int(color[4:6],16) )	
					self.ctxt.append([self.getpos()[1],color])
					self.index=self.index+1
					self.col = True

	def handle_endtag(self,tag):
		if tag == "span":
			if len(self.ctxt) >= self.index-1:
				self.ctxt[self.index-1].insert(1,self.getpos()[1])
			self.col = False
			
	def handle_data(self,data):
		if self.col == True:
			self.ctxt[-1].append(data)
			self.txt.append(self.ctxt[-1])
		else:
			self.txt.append([self.getpos()[1] , self.getpos()[1]+len(data) , None , data])
		
	

class Button(object):
	def __init__(self,datei,pos,action):
		# datei: bilddatei, es muss ein bild-p.png existieren
		# pos: position, relativ zur oberen linken Bildschirmecke
		# action: string zur action identification in einer if schleife
		self.datei = datei	
		self.datei_pressed = self.datei[:-4]+"-p"+self.datei[-4:]
		self.pos = pos
		
		self.action = action
		self.img = pygame.image.load(datei).convert_alpha()
		self.rect = self.img.get_rect().move(self.pos)
		self.size = [self.rect.width,self.rect.height]
	
		self.state = False
		
	def move(self,pos):
		self.pos = pos
		self.rect = self.img.get_rect().move(self.pos)
	
	def pressed(self):
		self.state = True
		if os.path.exists(self.datei_pressed):
			self.img = pygame.image.load(self.datei_pressed).convert_alpha()
	def unpressed(self):
		self.state = False
		self.img = pygame.image.load(self.datei).convert_alpha()
	



class Label(object):
	def __init__(self,pos=(0,0),size=(1,1),text="",mode="unichrome"):
		self.font = pygame.font.Font("FreeMono.ttf",12)
		self.pos = pos
		self.size = size
		self.spacing = 5
		self.color = (0,0,0)
		self.bg = (255,255,255,0)
		self.fsize = 12
		self.mode = mode
		
		self.imprimer(text)
		
	def imprimer(self,text,size=(1,1)):
		text=str(text)
		text = text.split("\n")
		# grösse in px automatisch herrausfinden
		if size == (1,1):
			for l in text:
				if len(l) > self.size[0]:
					self.size=(len(l),len(text))
		img = pygame.Surface( (self.size[0]*self.fsize , self.size[1]*(self.fsize + self.spacing) ) , flags=pygame.SRCALPHA)
		img.fill(self.bg)
		l=0
		# rendern jeder Zeile
		for t in text:
			if self.mode == "unichrome":
				temp = self.font.render(t,1,self.color)
				temp_rect = temp.get_rect().move( (0,l*(self.fsize + self.spacing)) )
				img.blit(temp,temp_rect)
			# html markup: <span style="color:#RRGGBB">colored text</span>
			elif self.mode == "colored":
				textl = colortext()
				textl.feed(t)
				spacing = 0
				for el in textl.txt:
					if el[2] != None:
						color = el[2]
					else:
						color = self.color
					temp = self.font.render(el[3],1,color)
					temp_rect = temp.get_rect().move( (spacing,l*(self.fsize + self.spacing)) )
					spacing = spacing + self.font.size(el[3])[0]
					img.blit(temp,temp_rect)

			l= l+1
		self.img = img 
		self.rect = self.img.get_rect().move(self.pos)
	
	def clear(self):
		self.img = pygame.Surface( (self.size[0]*self.fsize , self.size[1]*(self.fsize + self.spacing) ) , flags=pygame.SRCALPHA)
	def font_resize(self,fsize):
		self.font = pygame.font.Font("FreeMono.ttf",fsize)
		self.fsize = fsize
		
	def set_mode(self,mode):
		if mode == "unichrome":
			self.mode = "unichrome"
		elif mode == "colored":
			self.mode = "colored"

	
		
class Speicherstand(object):
	#font = pygame.font.Font("Averia-Regular.ttf",22)
	font = pygame.font.Font("FreeMono.ttf",22)
	def __init__(self,icon,quant,pos=(0,0)):
		self.pos = pos
		self.color = (0,0,0)
		self.bg = (255,255,255,0)
		text = str(quant)
		text_img = Speicherstand.font.render(text,1,self.color)
		text_rect = text_img.get_rect().move((50+5,10))
		
		img = pygame.Surface( (50+5+text_rect.width , 50) , flags=pygame.SRCALPHA)
		img.fill(self.bg)
		img.blit(icon,icon.get_rect().move((0,0)) )
		img.blit(text_img , text_rect)
		self.img = img 
		self.rect = self.img.get_rect().move(self.pos)
		
