#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import sqlite3
import os.path
import sys
import pygame
from monde import Farm , Muehle , Markthaus, Baecker , Haus , Forsthaus
from helper import *
from leute import *

class Player(object):
	def __init__(self,wege,name , cash , pop , eing , ausg):
		self.name = name
		self.cash = cash
		self.einnahmen = eing
		self.ausgaben = ausg
		self.geb = []
		
		for t in range(0,50):
			self.geb.append({})

		self.leute = Leute()
		
	def get_geb(self,pos):
		for t in self.geb:
			for g in t:
				if str(pos) == g:
					return t[g]
					


class Players(object):
	def __init__(self,wege,datei):
		self.players = []
		self.leute = Leute()
		if os.path.exists(datei) == False:
			print "file specified does not exist"
			return False
		else:
			con = sqlite3.connect(datei)		
			con.row_factory = sqlite3.Row	# um später bei fetchone() mit listen arbeiten zu können 
			c= con.cursor()		
	
			c.execute('''select * from players''') 	# alles aus monde laden
			ok = True		# tempvariabel, fetchone gibt none aus wen nichts mehr da ist, vermeidung einer Endloschleife 
			players = {}
			while ok == True:
				r = c.fetchone()	# nächste row holen
				if r != None:
					keys= r.keys()	# players keys in den dicts
					t={}
					for k in keys:
						t[k]=str(r[k])
						# konvertiren der datatypes
						# stings bleiben strings
						if t[k] != "":
							if t[k][0] == "[" and t[k][-1] == "]":		# arrays
								t[k] = t[k].strip("[]").split(",")
								t[k][0] = int(t[k][0])
								t[k][1] = int(t[k][1])
							elif t[k].isdigit() or (t[k][0] == "-" and t[k][1:].isdigit()):			# ints
								t[k] = int(t[k])
							elif t[k] == "None":
								del t[k] 
					players[t["num"]] = t
				else:
					ok = False
			for p in players:
				self.players.append([])
			for p in players:
				self.players[ players[p]["num"] ] = Player(wege=wege,name=players[p]["name"] , cash = players[p]["cash"] , pop = players[p]["pop"] , eing = players[p]["eing"], ausg = players[p]["ausg"])			
			
			for s in ["farmen","markthauser","muehlen","baecker","hauser","forsthauser"]:
				c.execute("select * from "+s) 	# alles aus monde laden
				ok = True		# tempvariabel, fetchone gibt none aus wen nichts mehr da ist, vermeidung einer Endloschleife 
				geb = {}
				while ok == True:
					r = c.fetchone()	# nächste row holen
					if r != None:
						keys= r.keys()	# players keys in den dicts
						t={}
						for k in keys:
							t[k]=str(r[k])
							# konvertiren der datatypes
							t[k] = convert_from_string(t[k])
							
						if t["typ"] in [20]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Farm(dic=t)
						if t["typ"] in [23]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Forsthaus(dic=t)
						if t["typ"] in [15]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Markthaus(dic=t)
						if t["typ"] in [21]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Muehle(dic=t)
						if t["typ"] in [22]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Baecker(dic=t)
						if t["typ"] in [10]:
							self.players[t["player"]].geb[t["typ"]][str(t["pos"])] = Haus(dic=t)
					else:
						ok = False
		
	def update(self,monde):
		for player in self.players:
			delete_list = []		# faulenzende Leute werden nach der for-Schleife gelöscht, da ihr Fehlen die liste durcheinander bringt
			for leut in player.leute.leute:
				if leut.route != []:
					last_pos = leut.route[0]
					leut.forward()
					leut.korr = [0+(monde.zoom_size[monde.zoom][0]/4)  ,  -leut.rect.height + (monde.zoom_size[monde.zoom][1]/2) + (monde.zoom_size[monde.zoom][1]/4)]
					if leut.route != []:
						new_pos = leut.route[0]
						if (last_pos[0] == new_pos[0]+1 ) or (last_pos[0] == new_pos[0]-1):
							leut.img = pygame.image.load(leut.datei[:-10]+"v-z"+str(monde.zoom)+"-n.png").convert_alpha() 
						if (last_pos[1] == new_pos[1]+1 ) or (last_pos[1] == new_pos[1]-1):
							leut.img = pygame.image.load(leut.datei[:-10]+"h-z"+str(monde.zoom)+"-n.png").convert_alpha() 
						leut.dpos = monde.get(leut.route[0]).dpos[:]
						leut.dpos = [ leut.dpos[0] + leut.korr[0] , leut.dpos[1] + leut.korr[1]]
						leut.rect = leut.img.get_rect().move(leut.dpos)
	 				else:
						if (last_pos[0] == leut.seen[-1][0]+1 ) or (last_pos[0] == leut.seen[-1][0]-1):
							leut.img = pygame.image.load(leut.datei[:-10]+"v-z"+str(monde.zoom)+"-n.png").convert_alpha() 
						if (last_pos[1] == leut.seen[-1][1]+1 ) or (last_pos[1] == leut.seen[-1][1]-1):
							leut.img = pygame.image.load(leut.datei[:-10]+"h-z"+str(monde.zoom)+"-n.png").convert_alpha() 
						leut.dpos = monde.get(leut.seen[-1]).dpos[:]
						leut.dpos = [ leut.dpos[0] + leut.korr[0] , leut.dpos[1] + leut.korr[1]]
						leut.rect = leut.img.get_rect().move(leut.dpos)

 					
				## ist der Träger angekommen und die Todoliste noch nicht leer
				if (leut.route == []) and (len(leut.todo) >= 1):
					leut.end.speicherIO( leut.todo[0][0] , leut.todo[0][1])
					del leut.todo[0]
					## schicke den Träger zurück
					if leut.todo != []:
						leut.route = leut.seen[:]
						leut.seen = []
						leut.route.reverse()
						temp = leut.end
						leut.end = leut.start
						leut.start = temp
						del temp
					elif leut.todo == []:
						delete_list.append(leut)
			
			for d in delete_list:
				player.leute.kill(d)
						
						

	
