#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import sqlite3
import os.path
import sys
import pygame
import time

from helper import *
from leute import *
from wege import Wege


class Farm(object):
	def __init__(self,neu={},dic={}):
		if dic == {}:
			self.typ = 	neu["type"]
			self.prod = neu["prod"]
			self.prodv	= neu["prodv"]
			self.reqfeld	= neu["reqfeld"]
			self.aura = []
			self.speicher = {self.prod:0}
		else:
			self.typ = dic["typ"]
			self.prod = dic["prod"]
			self.prodv = dic["prodv"]
			self.reqfeld = dic["reqfeld"]
			self.aura = dic["aura"]
			self.speicher = dic["spe"]
	def ernte(self,monde):
		for f in self.aura:
			if monde[f[0]][f[1]].islink() == False:
				if monde[f[0]][f[1]].typ == self.reqfeld:
					self.speicher[self.prod] = self.speicher[self.prod] + self.prodv
	
	def speicherIO(self,typ,quant):
		if self.speicher.get(typ) == None:
			self.speicher[typ] = 0
		if self.speicher[typ] - quant != 0:
			print "Speicher IO " + str(quant) + " " + str(typ)  
			self.speicher[typ] = self.speicher[typ] - quant 			# Vorzeichen : -quant oder +quant
	
	def dump(self):
		return {"typ":self.typ , "prod":self.prod , "prodv":self.prodv , "reqfeld":self.reqfeld , "aura":self.aura , "spe":self.speicher}  

class Forsthaus(Farm):
	def __init__(self,neu={},dic={}):
		Farm.__init__(self,neu,dic)
	#def ernte()
	
	#def dump(self):
		

class Haus(object):
	def __init__(self,neu={},dic={}):
		if dic == {}:
			self.typ = 	neu["type"]
			self.aura = []
			self.speicher = {}
			self.verbrauch = {}
			for key in neu:
				if key[0:6] == "verbr_":
					self.verbrauch[ int(key[-3:]) ] = neu[key]
					self.speicher[ int(key[-3:]) ]  = 0
			self.zufrieden = {}
			for key in self.verbrauch:
				self.zufrieden[key] = 100
			self.einwohner = 1
			self.max_einwohner = neu["max_einwohner"]
			self.stimmung = 100
			self.next_zuwachs = 0
		else:
			self.typ = dic["typ"]
			self.aura = dic["aura"]
			self.speicher = dic["spe"]
			self.verbrauch = dic["verbrauch"]
			self.zufrieden = dic["zufrieden"]
			self.stimmung = dic["stimmung"]
			self.max_einwohner = dic["max_einwohner"]
			self.einwohner = dic["einwohner"]
			self.next_zuwachs = 0 

	def speicherIO(self,typ,quant):
		if self.speicher.get(typ) == None:
			self.speicher[typ] = 0
		if self.speicher[typ] - quant != 0:
			print "Speicher IO " + str(quant) + " " + str(typ)  
			self.speicher[typ] = self.speicher[typ] - quant 			# Vorzeichen : -quant oder +quant
			
	def konsum(self):
		total_stimmung = 0
		for gut in self.verbrauch:
			if self.speicher.get(gut) != None:
				if self.speicher[gut] - self.verbrauch[gut] >= 0:
					if self.zufrieden[gut] < 100:
						self.zufrieden[gut] = self.zufrieden[gut] +5  
					self.speicher[gut] = self.speicher[gut] - self.verbrauch[gut]
				else:
					if self.zufrieden[gut] >0 :
						self.zufrieden[gut] = self.zufrieden[gut] -5 
			total_stimmung = total_stimmung + self.zufrieden[gut]
		self.stimmung = total_stimmung / len(self.zufrieden)  		
	
	def dump(self):
		return {"typ":self.typ , "aura":self.aura , "spe":self.speicher , "verbrauch": self.verbrauch, "zufrieden":self.zufrieden , "stimmung" : self.stimmung , "max_einwohner" : self.max_einwohner , "einwohner" : self.einwohner}  

class Muehle(object):
	def __init__(self,neu={},dic={}):
		if dic == {}:
			self.typ = 	neu["type"]
			self.prod = neu["prod"]
			self.prodv	= neu["prodv"]
			self.reqgut	= neu["reqgut"]
			self.aura = []
			self.speicher = {self.prod:0}
		else:
			self.typ = dic["typ"]
			self.prod = dic["prod"]
			self.prodv = dic["prodv"]
			self.reqgut = dic["reqgut"]
			self.aura = dic["aura"]
			self.speicher = dic["spe"]
			
	def produktion(self):
		if self.speicher.get(self.reqgut) != None:
			if self.speicher[self.reqgut] - self.prodv*self.prod >= 0:
				self.speicher[self.reqgut] = self.speicher[self.reqgut] - self.prodv*self.prod
				self.speicher[self.prod] = self.speicher[self.prod] +  self.prodv*self.prod
		 	
			
	def speicherIO(self,typ,quant):
		if self.speicher.get(typ) == None:
			self.speicher[typ] = 0
		if self.speicher[typ] - quant >= 0:
			print "Speicher IO " + str(quant) + " " + str(typ)  
			self.speicher[typ] = self.speicher[typ] - quant 			# Vorzeichen : -quant oder +quant
		else:
			print "nicht genügend Gut im Speicher"
	
	def dump(self):
		return {"typ":self.typ , "prod":self.prod , "prodv":self.prodv , "reqgut":self.reqgut , "aura":self.aura , "spe":self.speicher}  


class Baecker(Muehle):
	def __init__(self,neu={},dic={}):
		if dic == {}:
			Muehle.__init__(self,neu=neu)
		else:
			Muehle.__init__(self,neu=neu,dic=dic)

	
		
class Markthaus(object):
	def __init__(self,neu={},dic={}):
		if dic == {}:
			self.typ = 	neu["type"]
			self.aura = []
			self.speicher = {}
		else:
			self.typ = dic["typ"]
			self.aura = dic["aura"]
			self.speicher = dic["spe"]	
			
	def speicherIO(self,typ,quant):
		if self.speicher.get(typ) == None:
			self.speicher[typ] = 0
		if self.speicher[typ] - quant >= 0:
			print "Speicher IO " + str(quant) + " " + str(typ)  
			self.speicher[typ] = self.speicher[typ] - quant 			# Vorzeichen : -quant oder +quant
			
	def dump(self):
		return {"typ":self.typ , "aura":self.aura , "spe":self.speicher}  
	
		


class Case(object):
	def __init__(self,pos,size,datei,typ,bauen,neu,link=None):
		self.pos = pos
		if link == None:
			self.dpos = [0,0]
			self.npos = [0,0]
			self.typ = typ
			self.datei = datei
			self.zoom = int(self.datei[-7])
			if self.zoom == 1:
				size2 =  [neu[self.typ]["size2"][0]/2 , neu[self.typ]["size2"][1]/2]
			elif self.zoom == 2:
				size2 =  neu[self.typ]["size2"]
			elif self.zoom == 0:
				size2 =  [neu[self.typ]["size2"][0]/4 , neu[self.typ]["size2"][1]/4]
			if neu[self.typ].get("multifr") == 1:
				self.multiframe = [1,size2]
				self.img= load_multiframe(datei,size2)
				self.rect = self.img[0].get_rect()
			else:	
				self.multiframe = [0,size2]
				self.img = pygame.image.load(self.datei).convert_alpha()
				self.rect = self.img.get_rect()
			self.korr =0
			self.bauen = bauen
			self.size = size
			self.link = None
		else:
			self.link = link 
	def islink(self):
		if self.link == None:
			return False
		else:
			return True
	
	def __light__(self,t):
		self.datei = self.datei[:-6] + "-"+t+".png" 
		if self.multiframe[0] == 1:
			self.img = load_multiframe(self.datei, self.multiframe[1])
		else:
			self.img = pygame.image.load(self.datei).convert_alpha()

	def highlight(self):
		self.__light__("b")

	def darken(self):
		self.__light__("d") 
	def unhighlight(self):
		self.__light__("n")


class Monde(object):
	def __init__(self,datei):
		
		## neu	
		##########################
		datei_bgr = open("bgruppen.txt","r",1)
		conf=""
		# alle lines in eine var schreiben
		ok = False		# nur zwischen begin[ebjects] und end[objects] suchen
		for line in datei_bgr.readlines():
			if line == "begin[objects]\n":
				ok = True
			if line == "end[objects]\n":
				ok = False
				break
			if ok == True:
				conf=conf+line
		datei_bgr.close()		# schliesse datei
	
		conf = conf.expandtabs() # alle tab zeichen in spaces umwandels
		neu={}
		while conf.strip("\n").strip() != "":		# es bleiben eventuell noch spaces und line breaks (wenn die nicht verschwinden -> endloschleife)
			o={}	
			i = conf.find("{")	# anfang
			i2 = conf.find("}")	# ende
			item = conf[i+1:i2]	
			item = item.split("\n")
			for e in item:	
				if e != "":
					e= e.split(":")
					e[1] = e[1].strip().strip('"').strip()	# entferne " von den values der optionen
					e[0] = e[0].strip()		# entferne spaces von index der optionen
					o[e[0]] = e[1].strip().strip('"').strip()	
			neu[int(o["type"])] = o			# erstellung von neu (index muss int sein)
			conf = conf[i2+1:]		# decremenierung um {...}
	
		# types
		for r in neu:
			for r2 in neu[r]:
				# stings bleiben strings
				if neu[r][r2][0] == "[" and neu[r][r2][-1] == "]":		# arrays
					neu[r][r2] = neu[r][r2].strip("[]").split(",")
					for i in range(len(neu[r][r2])):
						neu[r][r2][i] = int(neu[r][r2][i])
				elif neu[r][r2].isdigit():			# ints
					neu[r][r2] = int(neu[r][r2])
				elif neu[r][r2].split(".")[0].isdigit() and neu[r][r2].split(".")[1].isdigit():			# floats
					neu[r][r2] = float(neu[r][r2])
	
		self.neu = neu

		## monde	
		##########################
		if os.path.exists(datei) == False:
			print "Datei '" + str(datei) + "' existiert nicht"
			sys.exit()
		else:
			con = sqlite3.connect(datei)		
			con.row_factory = sqlite3.Row	# um später bei fetchone() mit listen arbeiten zu können 
			c= con.cursor()		
			c.execute('''select * from monde''') 	# alles aus monde laden
			
			ok = True		# tempvariabel, fetchone gibt none aus wen nichts mehr da ist, vermeidung einer Endloschleife 
			monde = []
			while ok == True:
				r = c.fetchone()	# nächste row holen
				if r != None:
					keys= r.keys()	# monde keys in den dicts
					t={}
					for k in keys:
						t[k]=str(r[k])
						# konvertiren der datatypes
						# stings bleiben strings
						if t[k] != "":
							if t[k][0] == "[" and t[k][-1] == "]":		# arrays
								t[k] = t[k].strip("[]").split(",")
								t[k][0] = int(t[k][0])
								t[k][1] = int(t[k][1])
							elif t[k].isdigit() or (t[k][0] == "-" and t[k][1:].isdigit()):			# ints
								t[k] = int(t[k])
							elif t[k] == "None":
								del t[k] 
					monde.append(t)
				else:
					ok = False 
			con.close()		# schliesse datei

			
			## neues array initialisieren
			#--------------------
			monde2=[]
			k=0
			for j in monde:
				if j != {}:
					if j["pos"][0] > k:
						k =  j["pos"][0]
			n=0
			for m in monde:
				if m != {}:
					if m["pos"][1] > n:
						n = m["pos"][1]
			
			for each in range (0,k+1):
				monde2.append([])
				for each in range(0,n+1):
					monde2[-1].append([])
					
			## neues array füllen
			#--------------------
			
			for l in monde:
				if l != {}:
					if l.get("link") == None:
						monde2[ l["pos"][0] ][ l["pos"][1] ] = Case(l["pos"],l["size"],l["datei"],l["type"],l["bauen"],self.neu)
					else:
						monde2[ l["pos"][0] ][ l["pos"][1] ] = Case(l["pos"],None,None,None,None,self.neu,l["link"])

			
			
		## 	Sonstige	
		##########################
		self.monde = monde2
		self.draw=[]
		self.wege = Wege(self.monde)
		self.bauen = []
		self.zoom = 2
		self.champs = [1,3]
		self.batiments = [10,11,15,20,21,22,23]
		self.chemins = [2]
		self.zoom_size = [[26,15],[52,30],[104,60]]

	
	def get(self,pos):
		return self.monde[pos[0]][pos[1]]
	
	def Spielbrett(self,z,begin=[0,0]):
		
		### bestimmen von den verschiedenen zoom grössen
		s=[]
		if z == 0:
			s = [26,15]
		elif z == 1:
			s = [52,30]
		elif z == 2:
			s = [104,60]
		### rechne positionen (dpos) aus		
		x=begin[0]-(s[1]/2)-10*z
		y=begin[1]-(s[1]/2)
		for i in range(0 , self.monde[-1][-1].pos[1] +1):
			for i2 in range(0 , self.monde[-1][i].pos[0] +1):
				x= x + (s[0]/2)		# alt 52
				y= y - (s[1]/2)		# alt 30
				if self.monde[i2][i].link == None:
					korrektur1 = self.monde[i2][i].rect.height - self.monde[i2][i].size[1]*(s[1])		# alt 60
					korrektur2 = (self.monde[i2][i].size[0] - 1)*(s[1]/2)		# alt 30
					self.monde[i2][i].rect = self.monde[i2][i].rect.move(x,y-korrektur1-korrektur2)
					self.monde[i2][i].dpos = [x,y-korrektur1-korrektur2]
					self.monde[i2][i].korr = korrektur1
					self.monde[i2][i].npos = [x,y-korrektur2]
				elif self.monde[i2][i].link != None:
					self.monde[i2][i].npos = [x,y]
					
			y= begin[1]+(s[1]/2)*i		# alt 30
			x= begin[0]+(s[0]/2)*i		# alt 52
			
	
	def do_zoom(self):
		f = self.zoom
		# datei ändern (-zk -> -zk+1)
		for x in self.monde:
			for o in x:
				if o.islink() == False:
					o.datei = o.datei[:-9] + "-z"+str(f) + o.datei[-6:]
		# neu berechnung von monde
		### lade bild dateien	 
		for row in self.monde:
			for obj in row:
				if obj.islink() == False:
					if self.neu[obj.typ].get("multifr") == 1:
						if self.zoom == 0:
							size2 = [int(self.neu[obj.typ]["size2"][0]*0.25) , int(self.neu[obj.typ]["size2"][1]*0.25)]
						elif self.zoom == 1:
							size2 = [int(self.neu[obj.typ]["size2"][0]*0.5) , int(self.neu[obj.typ]["size2"][1]*0.5)]
						elif self.zoom == 2:
							size2 = self.neu[obj.typ]["size2"]
						obj.multiframe = [1,size2]
						obj.img= load_multiframe(obj.datei,size2)
						obj.rect = obj.img[0].get_rect()
					else:	
						obj.multiframe = [0,self.neu[obj.typ]["size2"]]
						obj.img = pygame.image.load(obj.datei).convert_alpha()
						obj.rect = obj.img.get_rect()
		middle = self.draw[len(self.draw)/2]
		print len(self.draw)
		print middle.pos
		begin = [middle.npos[0]-self.zoom_size[self.zoom][0]*middle.pos[0] , middle.npos[1]-self.zoom_size[self.zoom][1]*middle.pos[1]]
		print begin
		self.Spielbrett(f,begin=begin)
		# änderung von neu, so dass die richtigen grössen gebaut werden können
		for key in self.neu:
			self.neu[key]["datei"] = self.neu[key]["datei"][:-9] + "-z"+ str(f) + self.neu[key]["datei"][-6:]
		for n in range(0,50):
			if self.neu.get(n) != None:
				self.neu[n]["img"] = pygame.image.load(self.neu[n]["datei"]).convert_alpha()
				self.neu[n]["rect"] =  self.neu[n]["img"].get_rect()
		"""		
		self.draw=[]		
		l=len(self.monde)-1
		for i in range(0,l+1):
			cols=monde[l-i]
			for o in cols:
				if o.get("link") == None:	# 
					if -416 < o["dpos"][0] < (width +416)  and -240 < o["dpos"][1] < (height + 240):
						draw.append(o)
		"""		
	
	#		SCROLL
	#===================================
	#	updated die karte wenn der Spieler scrollt			
	def scroll(self,player,(width,height),speed):
		self.draw=[]
		mouse = pygame.mouse.get_pos()
		move=[0,0]
		if mouse[0] > (width - 10) :	# x richtung
			move=[-1*speed,0]
		if mouse[0] < 10:			# -x richtung
			move=[1*speed,0]
		if mouse[1] > (height -10) :	# y richtung
			move=[0,-1*speed]
		if mouse[1] < 10:		# -y richtung
			move=[0,1*speed]
		
		# draw muss in -x und +y Richtung aufgebaut werden !, wegen der Perspektive
		# also muss monde[] rückwärts durchlaufen werden
		"""
		l=len(self.monde)-1
		for i in range(0,l+1):
			cols=self.monde[l-i]
			for o in cols:
				if o.link == None:	
					o.dpos[0] =  o.dpos[0] + move[0]
					o.dpos[1] =  o.dpos[1] + move[1]
					o.npos[0] =  o.npos[0] + move[0]
					o.npos[1] =  o.npos[1] + move[1]
					if -512 < o.dpos[0] < (width +512)  and -512 < o.dpos[1] < (height + 512):
						self.draw.append(o)
						if self.neu[self.draw[-1].typ].get("multifr") == 1: 
							
							self.draw[-1].rect = o.img[0].get_rect().move(o.dpos)
						else:
							self.draw[-1].rect = o.img.get_rect().move(o.dpos)
						self.draw[-1].img = o.img
				elif o.link != None:
					o.npos[0] =  o.npos[0] + move[0]
					o.npos[1] =  o.npos[1] + move[1]
		"""
		maisons = []
		l=len(self.monde[-1])-1
		for y in range(0,l+1):
			l2 = len(self.monde)-1
			for x in range(l2,-1,-1):
				o = self.monde[x][y]
				if o.link == None:	
					o.dpos[0] =  o.dpos[0] + move[0]
					o.dpos[1] =  o.dpos[1] + move[1]
					o.npos[0] =  o.npos[0] + move[0]
					o.npos[1] =  o.npos[1] + move[1]
					if -512 < o.dpos[0] < (width +512)  and -512 < o.dpos[1] < (height + 512):
						self.draw.append(o)
						if self.neu[self.draw[-1].typ].get("multifr") == 1: 
							self.draw[-1].rect = o.img[0].get_rect().move(o.dpos)
						else:
							self.draw[-1].rect = o.img.get_rect().move(o.dpos)
						self.draw[-1].img = o.img
						
						if o.size != [1,1]:
							maisons.append(o) 
				elif o.link != None:
					self.draw.append(o)
					o.npos[0] =  o.npos[0] + move[0]
					o.npos[1] =  o.npos[1] + move[1]
		
		del x,y
		self.draw_repair = []
		for m in maisons:
			r = []
			## gehe den "Schatten" des hauses durch, dh den Bereich hinter dem Haus, der von den anderen Feldern nicht überlagert werden soll
			## diese Reparatur ist nötig, weil der hinrere Teil des Hauses durch andere Felder überlagert wird 
			for y in range(m.pos[1] , m.pos[1]+m.size[1]):	
				for x in range(m.pos[0]+m.size[0] , m.pos[0]+m.size[0] + 3):	
					if len(self.monde) > x:
						if len(self.monde[x]) > y:
							if self.monde[x][y].islink() == False:
								if m.rect.colliderect(self.monde[x][y].rect):	# überlagert- sich überhaupt etwas
									img = pygame.Surface( (self.monde[x][y].rect.width,self.monde[x][y].rect.height) , flags=pygame.SRCALPHA)	
									rect = img.get_rect()
									# zeichne die überlagerten Teile auf eine neue Surface neu. dabei muss der Bereich stimmen (mit delta der positionen)
									if self.neu[m.typ].get("multifr") == None:
										img.blit(m.img , pygame.Rect(m.rect.topleft[0]-self.monde[x][y].rect.topleft[0],m.rect.topleft[1]-self.monde[x][y].rect.topleft[1],10,10))
									else:
										img.blit(m.img[0] , pygame.Rect(m.rect.topleft[0]-self.monde[x][y].rect.topleft[0],m.rect.topleft[1]-self.monde[x][y].rect.topleft[1],10,10))
									self.draw_repair.append( [img , rect.move(self.monde[x][y].dpos), [m.pos[0]-1,m.pos[1]+m.size[1]-1]] )			# die letzte Liste bestimmt nach welchem Feld die Reparatur gezeichnet werden muss
							
		
		## die sich bewegende leute scrollen
		for l in player.leute.leute:
			l.dpos[0] = l.dpos[0] + move[0]
			l.dpos[1] = l.dpos[1] + move[1]
			if -416 < l.dpos[0] < (width +416)  and -240 < l.dpos[1] < (height + 240):
				l.rect = l.img.get_rect().move(l.dpos)	
		
		
	def Bauen(self,b):
		s=[];r=0
		cost=0
		mouse = pygame.mouse.get_pos()
		if self.zoom == 0:
			s = [26,15]
			r=10
		elif self.zoom == 1:
			s = [52,30]
			r=20
		elif self.zoom == 2:
			s = [104,60]
			r=40
			
		### nur wenn linke maustaste down
		if pygame.mouse.get_pressed()[0] == True:
			### heraussuchen des aktuellen Felds aus den angezeigten Felder 
			for o in self.draw:
				if o.islink() == False:
					if o.rect.contains(pygame.Rect((mouse[0]-(r/2),mouse[1]-(r/2),r,r))):
						if (b in self.champs) or (b in self.chemins) or (b==-1):
							if o.size == [1,1]:
								obj = self.monde[o.pos[0]][o.pos[1]]		# temp variabel, so das das arbeiten einfacher wird
								## erstes Feld markiert begin des zu zeichnenden Feldes 
								if self.bauen == []:		
									self.bauen.append(obj)  
								## aktuelles Feld markiert ende des Feld Rechtecks	
								if len(self.bauen) == 1:		# überschreibe das erste Feld nicht, wenn das Erste == das Letzte 
									self.bauen.append(obj) 
								else:
									self.bauen[-1] = obj 
									
								rect = [[],[]]
								## Rechteck erstellen
								if self.bauen[-1].pos[0] - self.bauen[0].pos[0] >= 0:	## x richtung
									rect[0] = range(self.bauen[0].pos[0] , self.bauen[-1].pos[0]+1)
								if self.bauen[-1].pos[0] - self.bauen[0].pos[0] <= 0:	## -x richtung
									rect[0] = range(self.bauen[-1].pos[0] , self.bauen[0].pos[0]+1)
								if self.bauen[-1].pos[1] - self.bauen[0].pos[1] >= 0:	## y richtung
									rect[1] = range(self.bauen[0].pos[1] , self.bauen[-1].pos[1]+1)
								if self.bauen[-1].pos[1] - self.bauen[0].pos[1] <= 0:	## -y richtung
									rect[1] = range(self.bauen[-1].pos[1] , self.bauen[0].pos[1]+1)	
								
								self.bauen = [self.bauen[0],self.bauen[-1]]		# bauen auf Anfan und Ende zurücksetzen
								for i in rect[0]:
									for i2 in rect[1]:	
										if (b in self.champs) or (b==-1):						
											if ((self.monde[i][i2].islink() == False) and (self.monde[i][i2].bauen == 1 )): #or ((self.monde[i][i2].islink()) and (self.monde[self.monde[i][i2].link[0]][self.monde[i][i2].link[1]].bauen == 1 )):					
												self.bauen.insert(1,self.monde[i][i2])		# andere Felder zwischen Anfang und Ende !!wichtig!!
										elif (b in self.chemins):
												#							i=end[0]
												#							 |	
												#							 v		
												#i2=begin[1]	->	b=========
												#i2!=begin[1]	->	        ||
												#i2!=begin[1]	->	        ||
												#		    			    e
												# baue weg nur wenn die aktuelle y koord die des begins  ist (horizontal) oder wenn die aktuelle x variabel die des endes ist (vertikal)
												if (i2 == self.bauen[0].pos[1]) or (i2 != self.bauen[0].pos[1] and i == self.bauen[-1].pos[0]):
													# ist link inexistent und bauen genemigt
													if ((self.monde[i][i2].islink() == False) and (self.monde[i][i2].bauen == 1 )):
														self.bauen.insert(1,self.monde[i][i2])
								
						if (b in self.batiments):
							if o.size == [1,1]:
								ok = True
								# bebaubar test
								#	--------------------------
								for x in range(o.pos[0] , o.pos[0] + self.neu[b]["size"][0]):		# von position bis position + size
									for y in range(o.pos[1] , o.pos[1] + self.neu[b]["size"][1]):
										# gehe links nach
										if self.monde[x][y].islink() == True:
											if self.monde[self.monde[x][y].link[0]][self.monde[x][y].link[1]].bauen == 0:
												ok = False
										# gibt est eine Koordinate, die nicht bebaubar ist, wird ok = False							
										elif self.monde[x][y].bauen == 0:
											ok = False
								del x , y   	# da x und y häufig sind
								
								# ist alles bebaubar, geht's los!
								# -------------------------------------
								if ok == True:
									obj = self.monde[o.pos[0]][o.pos[1]]		# temp var , besser manipulierbar als monde	
									self.bauen = [obj]	# hérédité der alten eigenschaften
									self.bauen[0].bauen = 0
		
									"""
									if self.neu[b].get("prod") != None:
										bauen["prod"] = neu[b]["prod"]
									"""
	
									for x in range(self.bauen[0].pos[0] , self.bauen[0].pos[0] + self.neu[b]["size"][0]):		# siehe test ob bebaubar
										for y in range(self.bauen[0].pos[1] , self.bauen[0].pos[1] + self.neu[b]["size"][1]):
											if not ((x == self.bauen[0].pos[0]) and (y == self.bauen[0].pos[1])):		# erste koordinate natürlich nicht überschreiben (ref)
												npos = self.monde[x][y].npos
												self.bauen.append(Case(self.monde[x][y].pos,None,None,None,None,self.neu,self.bauen[0].pos))
												self.bauen[-1].npos = npos 
	
						if (b==-1) and (len(self.bauen)==0):
							print "gggggg"
							self.bauen = [self.monde[o.pos[0]][o.pos[1]]]	# hérédité der alten eigenschaften
							self.bauen[0].bauen = 1
							print self.bauen[0].size[0]
							for x in range(self.bauen[0].pos[0] , self.bauen[0].pos[0] + self.bauen[0].size[0]):		# siehe test ob bebaubar
								for y in range(self.bauen[0].pos[1] , self.bauen[0].pos[1] + self.bauen[0].size[1]):
									if not ((x == self.bauen[0].pos[0]) and (y == self.bauen[0].pos[1])):		# erste koordinate natürlich nicht überschreiben (ref)
										npos = self.monde[x][y].npos[:]
										#self.bauen.append(Case(pos=[x,y],size=[1,1],datei=self.neu[1]["datei"],typ=1,bauen=1,neu=self.neu))
										self.bauen.append(self.monde[x][y])
	
																				

		### wird maustaste  losgelassen
		if (pygame.mouse.get_pressed()[0] == False) and (self.bauen != []):  
			print "baue Feld von " + str(self.bauen[0].pos) + " nach " + str(self.bauen[-1].pos) + " des Typs " + str(b)
			if b != -1:
				for obj in self.bauen:
					if obj.islink() == False:
						obj.size = self.neu[b]["size"]
						if self.neu[b].get("multifr") == 1:
							obj.img = load_multiframe(self.neu[b]["datei"],self.neu[b]["size2"])
							obj.rect = obj.img[0].get_rect()
							obj.multiframe = [1,self.neu[b]["size2"]]
						else:
							obj.img = pygame.image.load(self.neu[b]["datei"]).convert_alpha()#self.neu[b]["img"]  # kopiere img aus self.neu 
							obj.rect = obj.img.get_rect()
							
						obj.datei = self.neu[b]["datei"]  # kopiere datei namen aus self.neu 
						## errechnen der Korrektur
						korrektur = obj.rect.height - obj.size[1]*s[1] +((obj.size[1]-1)*(s[1]/2))		# warum +60? ## +((bauen["size"][1]-1)*(s[1]/2)) --> try&error , weitere Korrektur, da das Erste Feld der belegten Felder genutzt wird, dann aber ein Unterschied zwischen den oberen linken ecken besteht , bei neuberrechnung (init_monde), wird dieser schritt unnötig
						obj.korr = korrektur
						## rest 
						obj.dpos = [obj.npos[0] , obj.npos[1] - korrektur]
						obj.rect = obj.rect.move(obj.dpos)
						obj.typ = b
						#if obj.typ in [20]:
					if b == 2:
						self.wege = Wege(self.monde)		
					else:
						self.monde[obj.pos[0]][obj.pos[1]] = obj
				
			else:		##  Löschen
				for obj in self.bauen:
					obj.size = self.neu[1]["size"]
					obj.img = pygame.image.load(self.neu[1]["datei"]).convert_alpha()  # kopiere img aus self.neu 
					obj.rect = obj.img.get_rect()		
					obj.datei = self.neu[1]["datei"]  # kopiere datei namen aus self.neu 
					## errechnen der Korrektur
					obj.korr = 0
					## rest 
					obj.dpos = [obj.npos[0] , obj.npos[1]]
					obj.rect = obj.rect.move(obj.dpos)
					obj.typ = 1
					obj.link = None
					obj.bauen = 1
					self.wege = Wege(self.monde)
					#if obj.typ in [20]:
			self.bauen = []		# reset von bauen
	
	
	def update(self,players):
		for p in players:
			### Farmen
			for t in [20,23]:
				for g in p.geb[t]:
					p.geb[t][g].ernte(self.monde)
			### Mühlen
			for t in [21,22]:
				for g in p.geb[t]:
					p.geb[t][g].produktion()
			### Häuser
			for t in [10]:
				for g in p.geb[t]:
					p.geb[t][g].konsum()

			### Markthäuser
			for t in [15]:
				for g in p.geb[t]:
					## Position des Gebäudes von string nach list konv
					g_pos = g.strip("[]").split(",")
					g_pos[0] = int(g_pos[0].strip()) ; g_pos[1] = int(g_pos[1].strip())
					anschluss_markt= anschluss_geb(self.monde , g_pos)		# finde die Wegstücke um das Gebäude herum
					if anschluss_markt != []:		# Ist das Markthaus gar nicht an das StrassenNetz angeschlossen , so tue gar nichts
						## Durchgehen jedes Aura feldes des Markthauses
						for a in p.geb[t][g].aura:
							if self.get(a).islink() == False:
								## Ist eine Farm in der Nähe?
								for tf in [20,23]:
									if self.get(a).typ == tf:
										if p.get_geb(a).speicher.get(p.get_geb(a).prod) >7:		# ist der speicher der Farm > 7
											anschluss_farm = anschluss_geb(self.monde , a) 
											if anschluss_farm != []:		# ist die Farm nicht an das Strassennetz gebunden, so tue nichts
												ok = True					# ist schon jemand unterwegs blockiere !!
												for l in p.leute.leute:
													if l.end ==  p.get_geb(a):
														ok = False
												if ok == True:
													##  schicke jemanden die Ware abzuholen
													p.leute.leute.append(Traeger(self , start=anschluss_markt, stop=anschluss_farm , geb=[p.geb[t][g] , p.get_geb(a)]  ) )
													if p.leute.leute[-1].route != []:
														p.leute.leute[-1].todo.append( [p.get_geb(a).prod , p.leute.leute[-1].max_spe ] )
														p.leute.leute[-1].todo.append( [p.get_geb(a).prod, -1*p.leute.leute[-1].max_spe] )
														print p.leute.leute[-1].todo
													else:		# gibt es keinen Weg zwischen den Gebäuden, so löschen den Träger wieder
														del p.leute.leute[-1]
								## Ist eine Müle in der Nähe?
								for tf in [21,22]:
									if self.get(a).typ == tf:
										if  p.geb[t][g].speicher.get( self.neu[tf]["reqgut"] ) >6:		# ist der speicher von Blé > 6
											anschluss_farm = anschluss_geb(self.monde , a) 
											if anschluss_farm != []:		# ist die Farm nicht an das Strassennetz gebunden, so tue nichts

												if p.leute.unterwegs(p.get_geb(a)) == False:		## ist schon jemand unterwegs, tue nichts
													##  schicke jemanden die Ware ZU BRINGEN
													p.leute.leute.append(Traeger(self , start=anschluss_markt, stop=anschluss_farm , geb=[p.geb[t][g] , p.get_geb(a)]  ) )
													if p.leute.leute[-1].route != []:
														p.geb[t][g].speicher[p.get_geb(a).reqgut] = p.geb[t][g].speicher[p.get_geb(a).reqgut] - 5
														p.leute.leute[-1].todo.append( [p.get_geb(a).reqgut, -1*p.leute.leute[-1].max_spe] )
													else:		# gibt es keinen Weg zwischen den Gebäuden, so löschen den Träger wieder
														del p.leute.leute[-1]

										if p.get_geb(a).speicher.get(p.get_geb(a).prod) >7:		# ist der speicher der Mühle > 7
											anschluss_farm = anschluss_geb(self.monde , a) 
											if anschluss_farm != []:		# ist die Farm nicht an das Strassennetz gebunden, so tue nichts

												if p.leute.unterwegs(p.get_geb(a)) == False:		## ist schon jemand unterwegs, tue nichts
													##  schicke jemanden die Ware abzuholen
													p.leute.leute.append(Traeger(self , start=anschluss_markt, stop=anschluss_farm , geb=[p.geb[t][g] , p.get_geb(a)]  ) )
													if p.leute.leute[-1].route != []:
														p.leute.leute[-1].todo.append( [p.get_geb(a).prod , p.leute.leute[-1].max_spe ] )
														p.leute.leute[-1].todo.append( [p.get_geb(a).prod, -1*p.leute.leute[-1].max_spe] )
														print p.leute.leute[-1].todo
													else:		# gibt es keinen Weg zwischen den Gebäuden, so löschen den Träger wieder
														del p.leute.leute[-1]
								
								for tf in [10]:
									haus = p.get_geb(a)
									anschluss_haus = anschluss_geb(self.monde , a) 
									if anschluss_haus != []:
										if self.get(a).typ == tf:
											einkaufszettel = []
											for gut in p.get_geb(a).verbrauch:
												if (haus.speicher[gut] == 0) and (p.geb[t][g].speicher.get(gut) != None):
													if p.geb[t][g].speicher[gut] > 0:
														einkaufszettel.append(gut)
														if len(einkaufszettel) == 2:
															break
														
											if (len(einkaufszettel) != 0):
												if p.leute.unterwegs(p.get_geb(a)) == False:		## ist schon jemand unterwegs, tue nichts
													##  schicke jemanden die Ware abzuholen
													p.leute.leute.append(Einwohner(monde=self,start=anschluss_haus, stop=anschluss_markt , geb=[p.get_geb(a) , p.geb[t][g]]  ) )
													if p.leute.leute[-1].route != []:
														p.leute.leute[-1].todo.append( [einkaufszettel[0] , p.leute.leute[-1].max_spe ] )
														p.leute.leute[-1].todo.append( [einkaufszettel[0] , -1*p.leute.leute[-1].max_spe ] )
														print p.leute.leute[-1].todo
													else:		# gibt es keinen Weg zwischen den Gebäuden, so löschen den Träger wieder
														del p.leute.leute[-1]
											
										
	
	def save(self,filen,players):
		gebkeys = ["pos","prod","prodv","spe","reqfeld"]
		if os.path.exists(filen) == False:
			print "Die Datei " + filen + " exestiert nicht ... sie wird angelegt"
			create_file(filen)
		con = sqlite3.connect(filen)
		con.row_factory = sqlite3.Row
		c= con.cursor()
		
		### Save monde
		c.execute('''delete from monde''')
		con.commit()
		for r in self.monde:
			for e in r:
				if e.islink() == False:
					ins = [ 
					str(e.pos),
					str(e.datei),
					str(e.typ),
					str(e.bauen),
					str(e.size),
					None]		# diese Reienfolge ist wichtig !!!
				else:
					ins = [str(e.pos),None,None,None,None,str(e.link)]		# diese Reienfilge ist wichtig !!!
				c.execute('''insert into monde values(?,?,?,?,?,?)''',ins)
		con.commit()

		## save players
		c.execute('''delete from players''')
		c.execute('''delete from farmen''')
		c.execute('''delete from muehlen''')
		c.execute('''delete from markthauser''')
		c.execute('''delete from hauser''')
		c.execute('''delete from forsthauser''')
		c.execute('''delete from baecker''')
		con.commit()
		for p in players:
			exe = [players.index(p), str(p.name) , p.cash, 0,0,0]		# ID , Name , Cash , Population , Ausgaben , Einnahmen
			c.execute('''insert into players values(?,?,?,?,?,?)''',exe)
			## save gebäude
			for geb_typ in p.geb:
				for obj in geb_typ:
					dic = geb_typ[obj].dump()
					dicstr = {}
					for e in dic:
						dicstr[e] = str(dic[e])
					## Farmen
					if dic["typ"] in [20,23]:
						savlist = [players.index(p),
						dic["typ"],
						obj,
						dicstr["prod"],
						dicstr["prodv"],
						dicstr["spe"],
						dicstr["reqfeld"],
						dicstr["aura"]]
					if dic["typ"] == 20:
						c.execute('''insert into farmen values(?,?,?,?,?,?,?,?)''',savlist)
					if dic["typ"] == 23:
						c.execute('''insert into forsthauser values(?,?,?,?,?,?,?,?)''',savlist)
					## Mühlen
					if dic["typ"] in [21,22]:
						savlist = [players.index(p),
						dic["typ"],
						obj,
						dicstr["prod"],
						dicstr["prodv"],
						dicstr["spe"],
						dicstr["reqgut"],
						dicstr["aura"]]
						if dic["typ"] == 21:
							c.execute('''insert into muehlen values(?,?,?,?,?,?,?,?)''',savlist)
						elif dic["typ"] == 22:
							c.execute('''insert into baecker values(?,?,?,?,?,?,?,?)''',savlist)
					## Markthäuser
					elif dic["typ"] in [15]:
						savlist = [players.index(p),dic["typ"],obj,dicstr["spe"],dicstr["aura"]]
						c.execute('''insert into markthauser values(?,?,?,?,?)''',savlist)
					## Häuser
					elif dic["typ"] in [10]:
						savlist = [players.index(p),dic["typ"],obj,dicstr["spe"],dicstr["aura"],dicstr["verbrauch"],dicstr["zufrieden"],dicstr["stimmung"],dicstr["max_einwohner"],dicstr["einwohner"]]
						c.execute('''insert into hauser values(?,?,?,?,?,?,?,?,?,?)''',savlist)
		con.commit()
		c.close()
		print "Welt in Datei " + filen + " gespeichert"
