#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
import pygame
import os
pygame.font.init()



class Button(object):
	def __init__(self,datei,pos,action):
		self.datei = datei	
		self.datei_pressed = self.datei[:-4]+"-p"+self.datei[-4:]
		self.pos = pos
		
		self.action = action
		self.img = pygame.image.load(datei).convert_alpha()
		self.rect = self.img.get_rect().move(self.pos)
		self.size = [self.rect.width,self.rect.height]
	
		self.state = False
		
	def move(self,pos):
		self.pos = pos
		self.rect = self.img.get_rect().move(self.pos)
	
	def pressed(self):
		self.state = True
		if os.path.exists(self.datei_pressed):
			self.img = pygame.image.load(self.datei_pressed).convert_alpha()
	def unpressed(self):
		self.state = False
		self.img = pygame.image.load(self.datei).convert_alpha()
	

class Label(object):
	font = pygame.font.Font("FreeMono.ttf",12)
	def __init__(self,pos=(0,0),size=(1,1),text=""):
		self.pos = pos
		self.size = size
		self.spacing = 5
		self.color = (0,0,0)
		self.bg = (255,255,255,0)
		
		text = text.split("\n")
		img = pygame.Surface( (size[0]*12 , size[1]*(12+self.spacing) ) , flags=pygame.SRCALPHA)
		img.fill(self.bg)
		l=0
		for t in text:
			temp = Label.font.render(t,1,self.color)
			temp_rect = temp.get_rect().move( (0,l*(12+self.spacing)) )
			img.blit(temp,temp_rect)
			l= l+1
		self.img = img 
		self.rect = self.img.get_rect().move(self.pos)
		
	def imprimer(self,text):
		text = text.split("\n")
		img = pygame.Surface( (self.size[0]*12 , self.size[1]*(12+self.spacing) ) , flags=pygame.SRCALPHA)
		img.fill(self.bg)
		l=0
		for t in text:
			temp = Label.font.render(t,1,self.color)
			temp_rect = temp.get_rect().move( (0,l*(12+self.spacing)) )
			img.blit(temp,temp_rect)
			l= l+1
		self.img = img 
		self.rect = self.img.get_rect().move(self.pos)
	def clear(self):
		self.img = pygame.Surface( (self.size[0]*12 , self.size[1]*(12+self.spacing) ) , flags=pygame.SRCALPHA)
	
		
class Speicherstand(object):
	font = pygame.font.Font("Averia-Regular.ttf",22)
	def __init__(self,icon,quant,pos=(0,0)):
		self.pos = pos
		self.color = (0,0,0)
		self.bg = (255,255,255,0)
		text = str(quant)
		text_img = Speicherstand.font.render(text,1,self.color)
		text_rect = text_img.get_rect().move((50+5,10))
		
		img = pygame.Surface( (50+5+text_rect.width , 50) , flags=pygame.SRCALPHA)
		img.fill(self.bg)
		img.blit(icon,icon.get_rect().move((0,0)) )
		img.blit(text_img , text_rect)
		self.img = img 
		self.rect = self.img.get_rect().move(self.pos)
		
