#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from gui import *


class Menu(object):
	font = pygame.font.Font("Averia-Regular.ttf",25)
	def __init__(self):
		self.pos = [0,768-200]
		self.freearea = {"pos":[0,0],"size":[200,200]}
		self.tablist = [Button(datei="menu/info.png",pos=[0,0],action="info") , Button(datei="menu/bauen.png",pos=[0,0],action="bauen") , Button(datei="menu/conf.png",pos=[0,0],action="conf")]
		self.infopannel = {"pos":[200,0],"bauen":[],"info":[],"conf":[]}
		self.background = {"datei":"menu/menu_bg-h.png","pos":[0,768-200]}
		self.background["img"] = pygame.image.load(self.background["datei"]).convert_alpha()
		self.background["rect"] = self.background["img"].get_rect().move(self.background["pos"])
		self.mode = ["info",0]
		self.info_selected = [0,0]
		self.player = 0
		self.waren = {110:{"icon":"waren/Weizen.png","img":None,"name":"Weizen"} , 111:{"icon":"waren/Mehl.png","img":None,"name":"Weizenmehl"}, 112:{"icon":"waren/Brot.png","img":None,"name":"Brot"}, 115:{"icon":"waren/Holz.png","img":None,"name":"Holz"}}
		for k in self.waren:
			self.waren[k]["img"]  = pygame.image.load(self.waren[k]["icon"]).convert_alpha()
		
		c =0
		for tab in self.tablist:
			tab.move([self.pos[0]+self.freearea["size"][0],self.pos[1]+c*(tab.size[1]+7)+7])
			c =c+1
		self.infopannel["info"] = [Label(pos=(self.pos[0]+250,self.pos[1]+10) , size=[20,10]) , Label(pos=(self.pos[0]+500,self.pos[1]+10),size=[30,10],text="")]
			
		#		LOAD MENU BAUEN
		#===================================
		datei_bgr = open("bgruppen.txt","r",1)
		conf=""
		# alle lines in eine var schreiben
		ok = False		# nur zwischen begin[ebjects] und end[objects] suchen
		for line in datei_bgr.readlines():
			if line == "begin[menu_bauen]\n":
				ok = True
			if line == "end[menu_bauen]\n":
				ok = False
				break
			if ok == True:
				conf=conf+line
		datei_bgr.close()		# schliesse datei
		
		conf = conf.expandtabs() # alle tab zeichen in spaces umwandels
		neu=[]
		while conf.strip("\n").strip() != "":		# es bleiben eventuell noch spaces und line breaks (wenn die nicht verschwinden -> endloschleife)
			o={}
			i = conf.find("{")	# anfang
			i2 = conf.find("}")	# ende
			item = conf[i+1:i2]	
			item = item.split("\n")
			for e in item:	
				if e != "":
					e= e.split(":")
					e[1] = e[1].strip().strip('"').strip()	# entferne " von den values der optionen
					e[0] = e[0].strip()		# entferne spaces von index der optionen
					o[e[0]] = e[1].strip().strip('"').strip()	
			neu.append(o)			# erstellung von neu (index muss int sein)
			conf = conf[i2+1:]		# decremenierung um {...}
	
		# types
		for r in neu:
			for r2 in r:
				# stings bleiben strings
				if r[r2][0] == "[" and r[r2][-1] == "]":		# arrays
					r[r2] = r[r2].strip("[]").split(",")
					r[r2][0] = int(r[r2][0])
					r[r2][1] = int(r[r2][1])
				elif r[r2].isdigit() or (r[r2][0] == "-" and r[r2][1:].isdigit()):			# ints
					r[r2] = int(r[r2])
		
		for b in neu:
			self.infopannel["bauen"].append(Button(b["datei"],b["pos"],b["type"]))
			self.infopannel["bauen"][-1].move( [b["pos"][0]+self.pos[0]+225  , b["pos"][1]+self.pos[1]] )
	
			
	def update(self):
		mouse =	pygame.mouse.get_pos()
		for tab in self.tablist:
			if tab.rect.collidepoint(mouse) and pygame.mouse.get_pressed()[0]:
				self.mode[0] = tab.action
				tab.pressed()
		
		for b in self.infopannel["bauen"]:
			if b.rect.collidepoint(mouse) and pygame.mouse.get_pressed()[0]:
				self.mode[1] = b.action
				b.pressed()		
			if b.state == True and self.mode[1] != b.action:
				b.unpressed() 
		
