#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#       untitled.py
#       
#       Copyright 2011 Johannes ter Haak <jojo@jojo3>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#       
#       

import pygame
import load,bauenf,logic,chemin


#		INIT MENU
#===================================		
#		initialisiert das menu .. position + elemente
def init_menu(width,height):
	pos = {"w":width,"h":200,"x":0,"y":height-200} #unten
	#pos = {"w":200,"h":height,"x":width-200,"y":0} #rechts
	#pos = {"w":200,"h":height,"x":0,"y":0} #links
	#pos = {"w":width,"h":200,"x":0,"y":0} #oben
	# lade menu bauen aus datei
	menu_bauen = load.load_menu_bauen()
	# menu bauen position relative -> absolute , lade bilder
	for m in menu_bauen:
		if pos["w"] != width:		# wenn menu links oder rechts
			m["pos"][0] = m["pos"][0] + pos["x"]#(width -200)
			m["pos"][1] = m["pos"][1] + pos["y"]+200#(200)
		elif pos["w"] == width:		# wenn menu oben oder unten
			tmp = m["pos"][0]
			m["pos"][0] = m["pos"][1] + pos["x"]+200 # +200 da menu_oben 200*200
			m["pos"][1] = tmp + pos["y"]		
		m["img"] = pygame.image.load(m["datei"]).convert_alpha()
		m["rect"] = m["img"].get_rect().move(m["pos"])

	### menu oben
	menu_oben = {"tabs":[{"datei" : "menu/info.png","pos" : [10,0], "size" : [25,25] , "type":"info"},{"datei" : "menu/bauen.png","pos" : [45,0], "size" : [25,25], "type":"bauen"},{"datei" : "menu/conf.png","pos" : [80,0], "size" : [25,25] , "type":"conf"}]}
	for mo in menu_oben["tabs"]:
		if pos["w"] != width:	# wenn menu links oder rechts 
			mo["pos"][0] = mo["pos"][0] + pos["x"]
			mo["pos"][1] = mo["pos"][1] + (200-mo["size"][1])
		elif pos["w"] == width:		# wenn menu oben oder unten
			tmp = mo["pos"][0]
			mo["pos"][0] = mo["pos"][1] + pos["x"]+200-mo["size"][1] # +200 da menu_oben 200*200
			mo["pos"][1] = tmp + pos["y"]
		mo["img"] = pygame.image.load(mo["datei"]).convert_alpha()
		mo["rect"] = mo["img"].get_rect().move(mo["pos"])
	
	### menu config
	menu_conf = [{"datei":"menu/button8.png","pos":[10,10],"size":[50,50],"type":"save"}] 
	for mc in menu_conf:
		if pos["w"] != width:	# wenn menu links oder rechts 
			mc["pos"][0] = mc["pos"][0] + (width -200)
			mc["pos"][1] = mc["pos"][1] + (200)
		elif pos["w"] == width:		# wenn menu oben oder unten
			tmp = mc["pos"][0]
			mc["pos"][0] = mc["pos"][1] + pos["x"]+200 # +200 da menu_oben 200*200
			mc["pos"][1] = tmp + pos["y"]
		mc["img"] = pygame.image.load(mc["datei"]).convert_alpha()
		mc["rect"] = mc["img"].get_rect().move(mc["pos"])
	
 	
	### menu
	menu = {"bauen": menu_bauen , "oben":menu_oben , "conf":menu_conf , "show":"" , "pos":pos} 
	return menu	
	
	
#		INIT MONDE
#===================================
#	stellt monde auf -- auch bei zoomwechsel				
def init_monde(monde,z):
	### bestimmen von den verschiedenen zoom grössen
	s=[]
	if z == 0:
		s = [26,15]
	elif z == 1:
		s = [52,30]
	elif z == 2:
		s = [104,60]
		
	### lade bild dateien	 
	for row in monde:
		for obj in row:
			if obj.get("link") == None:
				obj["img"] = pygame.image.load(obj["datei"]).convert_alpha()
				obj["rect"] = obj["img"].get_rect()
	### rechne positionen (dpos) aus		
	x=0
	y=0
	for i in range(0 , monde[-1][-1]["pos"][1] +1):
		for i2 in range(0 , monde[-1][i]["pos"][0] +1):
			x= x + (s[0]/2)		# alt 52
			y= y - (s[1]/2)		# alt 30
			if monde[i2][i].get("link") == None:
				korrektur1 = monde[i2][i]["rect"].height - monde[i2][i]["size"][1]*(s[1])		# alt 60
				korrektur2 = (monde[i2][i]["size"][0] - 1)*(s[1]/2)		# alt 30
				monde[i2][i]["rect"] = monde[i2][i]["rect"].move(x,y-korrektur1-korrektur2)
				monde[i2][i]["dpos"] = [x,y-korrektur1-korrektur2]
				monde[i2][i]["korr"] = korrektur1
				monde[i2][i]["npos"] = [x,y-korrektur2]
			elif monde[i2][i].get("link") != None:
				monde[i2][i]["npos"] = [x,y]
				
		if i == 0: 
			y= -(s[1]/2)		# alt 30
			x= -(s[0]/2)		# alt 52
		else:
			y= (s[1]/2)*i		# alt 30
			x= (s[0]/2)*i		# alt 52
			
	return monde
